package mole.state 
{
	import mole.entities.particles.CParticleEmitter;
	import mole.Main;
	import net.flashpunk.graphics.Image;
	import net.flashpunk.Entity;
	import net.flashpunk.FP;
	import net.flashpunk.graphics.Text;
	import net.flashpunk.utils.Input;
	import net.flashpunk.utils.Key;
	
	/**
	 * Ecran de game over.
	 * @author Cédric Liaudet
	 */
	public class CGameOver extends Entity implements IState
	{
		[Embed(source = '../../data/images/gameover.png')]
		private const GAME_OVER:Class;
		
		[Embed(source = '../../data/sounds/music_gameover.mp3')]
		private const MUSIC_GAME_OVER:Class;
		
		/**
		 * Constructeur par défaut.
		 */
		public function CGameOver() 
		{
			m_nParticles = 10.0;
			
			Text.size = 60;
			m_WinerButNotReally = new Text(Main.GameRules.GetWiner(), 64, 32);
			m_WinerButNotReally.smooth = true;
			m_WinerButNotReally.color = 0x00000000;
			m_WinerButNotReally.alpha = 0.8;			
		}
		
		/**
		 * Chargement des données.
		 */
		public function OnStart():void
		{
			Input.clear();
			Input.define("back", Key.ENTER, Key.ESCAPE);
			
			// On repositionne la caméra.
			FP.camera.x = FP.camera.y = 0;
			
			// chargement de l'image.
			graphic = new Image(GAME_OVER);
			Main.World.add(this);
			
			Main.World.addGraphic(m_WinerButNotReally).layer = 0;
			
			// On lance la musique.
			Main.SoundManager.PlayMusic(MUSIC_GAME_OVER, false);
		}
		
		/**
		 * Mise à jours de l'état.
		 */
		public function OnUpdate(): void
		{
			if (Input.pressed("back"))
			{
				Main.GameStateManager.SetCurrentState(new CMenu);
			}
			
			m_nParticles -= FP.elapsed;
			if (m_nParticles <= 0.0)
			{
				m_nParticles = 3.0;
				CParticleEmitter.GenerateParticlesAtPoint(CParticleEmitter.RangeRandom(0, 832), CParticleEmitter.RangeRandom(0, 320), 2, 2, 3, 4, -1, -1, 1, 1, 100, 150, 0);
			}
		}
		
		/**
		 * "Destruction" des données.
		 */
		public function OnEnd():void
		{
			Main.SoundManager.StopMusic(false);
		}
		
		/**
		 * Mise en pause
		 */
		public function OnPause():void
		{
			
		}
		
		/**
		 * Retour de pause
		 */
		public function OnResume():void
		{
			
		}
		
		private var m_nParticles:Number;
		private var m_WinerButNotReally:Text;
	}

}